#!/bin/bash

# start ssh-agent and load SSH keys

# Xavier Belanger
# April 26, 2025

infoFile=$HOME/.agent-info
killFile=$HOME/.agent-kill

# if an agent already exist, kill it
if [ -f $infoFile ]
then
	source $infoFile

	# check if the agent is still running (file and process)
	if [ -r $SSH_AUTH_SOCK ]
	then
		/usr/bin/ps -p $SSH_AGENT_PID > /dev/null
		if [ $? -eq 0 ]
		then
			/usr/bin/ssh-agent -k | /usr/bin/head -2 > $killFile
			source $killFile
		fi
		/bin/rm $infoFile $killFile
	else
		/bin/rm $infoFile
	fi
fi

# launch a fresh ssh agent 
/usr/bin/ssh-agent | /usr/bin/head -2 > $infoFile
/bin/chmod 0600 $infoFile
source $infoFile

# load all available keys
for pubkey in $(/bin/ls $HOME/.ssh/*.pub)
do
	key=$(/usr/bin/basename $pubkey .pub)
	/bin/true | /usr/bin/ssh-add  $HOME/.ssh/$key
done

# providing instructions for activating the agent
/bin/printf "In order to activate the SSH agent, please run the following command:\n"
/bin/printf "  source $infoFile\n"

# EoF
