#!/bin/bash

# Xavier Belanger
# November 11, 2024

# this script is covered by the BSD 2-Clause License

# copy a file with a timestamp and a version number

# the version number works from 01 to 99
# beyond that limit, the script will stop

# checking if an argument is present
if [ $# -lt 1 ]
then
	/bin/printf "usage: $0 file\n"
	exit 1
fi

# adding escapes sequences for spaces
filename=$(echo $1 | /bin/sed "s/ /\\ /g")

# checking if the argument is a regular file
if [ ! -f "$filename" ]
then
	/bin/printf "Bad argument\n"
	exit 1
fi

# checking if the file's directory is writeable
if [ ! -w $(/usr/bin/dirname "$filename") ]
then
	/bin/printf "Directory not writeable\n"
	exit 1
fi

timestamp=$(/bin/date +"%F")

# managing version number beyond the first one
if [ -r "$filename-$timestamp-01" ]
then
	version=2
	while [ -r "$filename-$timestamp-0$version" -o -r "$filename-$timestamp-$version" ]
	do
		let version=$(($version+1))
	done

	# version number lesser than 10
	if [ $version -lt 10 ]
	then
		/bin/cp -i -v "$filename" "$filename-$timestamp-0$version"

		if [ -x "$filename-$timestamp-0$version" ]
		then
			/bin/chmod -x "$filename-$timestamp-0$version"
		fi
	# version number equal or greater than 10
	else
		# version number reaching the limit
		if [ $version -gt 99 ]
		then
			/bin/printf "Maximum limit reached\n"
			exit 1
		else
			/bin/cp -i -v "$filename" "$filename-$timestamp-$version"

			if [ -x "$filename-$timestamp-$version" ]
			then
				/bin/chmod -x "$filename-$timestamp-$version"
			fi
		fi
	fi
	exit
fi

# copy #1
/bin/cp -i -v "$filename" "$filename-$timestamp-01"

if [ -x "$filename-$timestamp-01" ]
then
	/bin/chmod -x "$filename-$timestamp-01"
fi

# EoF
