#!/bin/bash

# Xavier Belanger
# April 14, 2025

# root privileges are required for this script
if [ $EUID -ne 0 ]
then
        /usr/bin/printf "You must use sudo to run this script\n"
        exit 1
fi

webrule=$(/usr/sbin/nft --handle --numeric list chain inet filter webtraffic | /usr/bin/grep "nftables-webtraffic" | /usr/bin/grep -o "[0-9]*$")

/usr/sbin/nft insert rule inet filter webtraffic handle $webrule tcp dport { 80, 443 } counter accept

# EoF
