#!/bin/bash

# Xavier Belanger
# April 12, 2025

# root-level privileges are required for this script
if [ $EUID -ne 0 ]
then
	/usr/bin/printf "You must use sudo to run this script\n"
	exit 1
fi

# get the list of domains from the domains.txt file
domains=$(/usr/bin/cut -d " " -f1 /etc/dehydrated/domains.txt)

for domain in $domains
do
	certDirectory=/var/lib/dehydrated/certs/$domain
	apacheDirectory=/etc/apache2/sites-certificates

	for file in cert chain privkey
	do
		/bin/cp $certDirectory/$file.pem $apacheDirectory/$domain-$file.pem
	done
done

/usr/bin/printf "You must restart Apache HTTPD for the new certificates to be activated.\n"

# EoF
